using System;
using Server.Network;

namespace Server.Items
{
	public class SOSPiece : Item
	{

		[Constructable]
		public SOSPiece() : this( 1 )
		{
		}

		[Constructable]
		public SOSPiece( int amount ) : base( 8814 )
		{
			Stackable = true;
			Weight = 0.1;
			Hue = 101;
			Amount = amount;
			Name = "a rare ancient SOS piece";
		}

		public SOSPiece( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
   
   public class FishAlbinoAngelfish : Item
	{

		[Constructable]
		public FishAlbinoAngelfish() : this( 1 )
		{
		}

		[Constructable]
		public FishAlbinoAngelfish( int amount ) : base( 15108 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Albino Angelfish";
		}

		public FishAlbinoAngelfish( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	

	public class NetPiece : Item
	{
		[Constructable]
		public NetPiece() : base( 0xDD5 )
		{
			Name = "Fishing Net Piece";
		      	Weight = 0.5;
			Movable = true;
            	}

		public NetPiece( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

            	}
	}
	
	public class FishAngelfish : Item
	{
		[Constructable]
		public FishAngelfish() : this( 1 )
		{
		}

		[Constructable]
		public FishAngelfish( int amount ) : base( 15115 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Angelfish";
		}

		public FishAngelfish( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishBladePlant : Item
	{
		[Constructable]
		public FishBladePlant() : this( 1 )
		{
		}

		[Constructable]
		public FishBladePlant( int amount ) : base( 3219 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Blade Plant";
		}

		public FishBladePlant( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishBlueCory : Item
	{
		[Constructable]
		public FishBlueCory() : this( 1 )
		{
		}

		[Constructable]
		public FishBlueCory( int amount ) : base( 15111 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Blue Cory";
		}

		public FishBlueCory( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	

	
	public class FishBrineShrimp : Item
	{
		[Constructable]
		public FishBrineShrimp() : this( 1 )
		{
		}

		[Constructable]
		public FishBrineShrimp( int amount ) : base( 15121 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Brine Shrimp";
		}

		public FishBrineShrimp( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishBritainiaCrownFish : Item
	{
		[Constructable]
		public FishBritainiaCrownFish() : this( 1 )
		{
		}

		[Constructable]
		public FishBritainiaCrownFish( int amount ) : base( 15103 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Britainia Crown Fish";
		}

		public FishBritainiaCrownFish( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishClownfish : Item
	{
		[Constructable]
		public FishClownfish() : this( 1 )
		{
		}

		[Constructable]
		public FishClownfish( int amount ) : base( 15105 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Clownfish";
		}

		public FishClownfish( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishFandancer : Item
	{
		[Constructable]
		public FishFandancer() : this( 1 )
		{
		}

		[Constructable]
		public FishFandancer( int amount ) : base( 15101 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Fandancer";
		}

		public FishFandancer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishFishies : Item
	{
		[Constructable]
		public FishFishies() : this( 1 )
		{
		}

		[Constructable]
		public FishFishies( int amount ) : base( 3543 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Fishies";
		}

		public FishFishies( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishGoldenBroadtail : Item
	{
		[Constructable]
		public FishGoldenBroadtail() : this( 1 )
		{
		}

		[Constructable]
		public FishGoldenBroadtail( int amount ) : base( 15107 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Golden Broadtail";
		}

		public FishGoldenBroadtail( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishJellyfish : Item
	{
		[Constructable]
		public FishJellyfish() : this( 1 )
		{
		}

		[Constructable]
		public FishJellyfish( int amount ) : base( 15118 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Jellyfish";
		}

		public FishJellyfish( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishMinocBlue : Item
	{
		[Constructable]
		public FishMinocBlue() : this( 1 )
		{
		}

		[Constructable]
		public FishMinocBlue( int amount ) : base( 15102 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Minoc Blue";
		}

		public FishMinocBlue( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishNujelmHoney : Item
	{
		[Constructable]
		public FishNujelmHoney() : this( 1 )
		{
		}

		[Constructable]
		public FishNujelmHoney( int amount ) : base( 15110 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Nujelm Honey";
		}

		public FishNujelmHoney( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishRainbowMolly : Item
	{
		[Constructable]
		public FishRainbowMolly() : this( 1 )
		{
		}

		[Constructable]
		public FishRainbowMolly( int amount ) : base( 15106 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Rainbow Molly";
		}

		public FishRainbowMolly( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishShrimp : Item
	{
		[Constructable]
		public FishShrimp() : this( 1 )
		{
		}

		[Constructable]
		public FishShrimp( int amount ) : base( 15124 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Shrimp";
		}

		public FishShrimp( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishSmallmouthSuckerfish : Item
	{
		[Constructable]
		public FishSmallmouthSuckerfish() : this( 1 )
		{
		}

		[Constructable]
		public FishSmallmouthSuckerfish( int amount ) : base( 15104 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Smallmouth Suckerfish";
		}

		public FishSmallmouthSuckerfish( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishSpeckledCrab : Item
	{
		[Constructable]
		public FishSpeckledCrab() : this( 1 )
		{
		}

		[Constructable]
		public FishSpeckledCrab( int amount ) : base( 15100 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Speckled Crab";
		}

		public FishSpeckledCrab( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishSpottedBucaneer : Item
	{
		[Constructable]
		public FishSpottedBucaneer() : this( 1 )
		{
		}

		[Constructable]
		public FishSpottedBucaneer( int amount ) : base( 15113 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Spotted Bucaneer";
		}

		public FishSpottedBucaneer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishSpottedPuffer : Item
	{
		[Constructable]
		public FishSpottedPuffer() : this( 1 )
		{
		}

		[Constructable]
		public FishSpottedPuffer( int amount ) : base( 15109 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Spotted Puffer";
		}

		public FishSpottedPuffer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishStripedSosarianSwill : Item
	{
		[Constructable]
		public FishStripedSosarianSwill() : this( 1 )
		{
		}

		[Constructable]
		public FishStripedSosarianSwill( int amount ) : base( 15114 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Striped Sosarian Swill";
		}

		public FishStripedSosarianSwill( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishVesperReefTiger : Item
	{
		[Constructable]
		public FishVesperReefTiger() : this( 1 )
		{
		}

		[Constructable]
		public FishVesperReefTiger( int amount ) : base( 15112 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Vesper Reef Tiger";
		}

		public FishVesperReefTiger( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}